﻿<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Kasa" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Pełna lista pracowników etatowych</title>
		<script runat="server">

            //Wspólny kod dla pracownicy - ewidencja, lista skrócona i lista pełna    
            [DefaultWidth(20)]
            public enum Filtr {
                Wszyscy, Pracownicy, PracownicyMłodociani,
            }

            [DefaultWidth(20)]
            public enum Zakres {
                Wszyscy, Przyjęci, Zwolnieni,
            }

            public class PrnParams : Soneta.Business.ContextBase {

                public PrnParams(Context context)
                    : base(context) {
                }

                Filtr filtr = Filtr.Pracownicy;
                [Priority(1)]
                public Filtr Filtr {
                    get { return filtr; }
                    set {
                        filtr = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                Zakres zakres;
                [Priority(2)]
                public Zakres Zakres {
                    get { return zakres; }
                    set {
                        zakres = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                bool przedluzenia = true;
                [Priority(3)]
                [Caption("Uwzgl. przedłużenia")]
                public bool Przedluzenia {
                    get { return przedluzenia; }
                    set {
                        przedluzenia = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                public bool Test(Pracownik idx, Date data, FromTo okres) {
                    bool bb = true;
                    if (Filtr != Filtr.Wszyscy || Zakres != Zakres.Wszyscy) {
                        PracHistoria historia = idx[data];
                        switch (Zakres) {
                            case Zakres.Przyjęci:
                                FromTo zatr1 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                                bb &= okres.Contains(zatr1.From);
                                break;
                            case Zakres.Zwolnieni:
                                FromTo zatr2 = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                                bb &= okres.Contains(zatr2.To);
                                break;
                        }
                        switch (Filtr) {
                            case Filtr.Pracownicy:
                                bb &= !Młodociany(historia.Etat.RodzajZatrudnienia);
                                break;
                            case Filtr.PracownicyMłodociani:
                                bb &= Młodociany(historia.Etat.RodzajZatrudnienia);
                                break;
                        }
                    }
                    return bb;
                }

                static bool Młodociany(RodzajZatrudnienia rodzaj) {
                    switch (rodzaj) {
                        case RodzajZatrudnienia.Uczeń1Klasy:
                        case RodzajZatrudnienia.Uczeń2Klasy:
                        case RodzajZatrudnienia.Uczeń3Klasy:
                        case RodzajZatrudnienia.MłodocianyPrzyuczany:
                            return true;
                        default:
                            return false;
                    }
                }
            }

            PrnParams pars;
            [Soneta.Business.Context(Required = true)]
            public PrnParams Params {
                set { pars = value; }
            }

            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                bool pelneStanowisko = false;
                [Priority(1)]
                [Caption("Stanowisko pełna nazwa")]
                public bool PelneStanowisko {
                    get { return pelneStanowisko; }
                    set {
                        pelneStanowisko = value;
                        OnChanged(EventArgs.Empty);
                    }
                }

                bool pelnaFunkcja = false;
                [Priority(2)]
                [Caption("Funkcja pełna nazwa")]
                public bool PelnaFunkcja {
                    get { return pelnaFunkcja; }
                    set {
                        pelnaFunkcja = value;
                        OnChanged(EventArgs.Empty);
                    }
                }                
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars {
                get { return srpars; }
                set { srpars = value; }
            }		
            		    
            protected void dc_ContextLoad(object sender, EventArgs e) {
                OkresContext ok = (OkresContext)dc[typeof(OkresContext)];
                FromTo okres = ok.Okres;
                Date data = ok.Aktualny;

                ReportHeader1["OKRES"] = okres.ToString();

                switch (pars.Zakres) {
                    case Zakres.Przyjęci:
                        ReportHeader1["CO"] = "Przyjętych do pracy w okresie";
                        break;
                    case Zakres.Zwolnieni:
                        ReportHeader1["CO"] = "Zwolnionych z pracy w okresie";
                        break;
                    default:
                        ReportHeader1["CO"] = "Zatrudnionych w okresie";
                        break;
                }

                switch (pars.Filtr) {
                    case Filtr.Pracownicy:
                        ReportHeader1["KTO"] = "pracowników etatowych";
                        break;
                    case Filtr.PracownicyMłodociani:
                        ReportHeader1["KTO"] = "pracowników młodocianych";
                        break;
                    default:
                        ReportHeader1["KTO"] = "wszystkich pracowników";
                        break;
                }

                Row[] rows = (Row[])dc[typeof(Row[])];
                ArrayList result = new ArrayList();
                foreach (Pracownik idx in rows)
                    if (pars.Test(idx, data, okres))
                        result.Add(idx);
                Grid1.DataSource = result;
            }

            void Grid1_BeforeRow(Object sender, RowEventArgs args) {
                PracHistoria ph = (PracHistoria)args.Row;

                string col1str = ph.Nazwisko; 
                if (ph.ImieDrugie != "")
                    col1str += "<br>" + ph.Imie + ", " + ph.ImieDrugie;
                else
                    col1str += "<br>" + ph.Imie;
                col1str += "<br>" + ph.PESEL;
                col1str += "<br>" + ph.Urodzony; 
                col1.EditValue = col1str;

                string col2str = ph.Adres.ToString();
                col2str += "<br>" + ph.AdresZameldowania.Telefon + ", " + ph.Dokument.SeriaNumer;
                RachunekBankowyPodmiotu rachunek = ((IPodmiotKasowy)ph.Pracownik).DomyslnyRachunek;
                if (rachunek != null) {
                    if (rachunek.Rachunek.Bank != null)
                        col2str += "<br>" + rachunek.Rachunek.Bank.Nazwa;
                    else
                        col2str += "<br>";
                    col2str += "<br>" + rachunek.Rachunek.Numer;
                }
                else
                    col2str += "<br><br>";
                col2.EditValue = col2str;

                string col3str = GetStanowisko(ph);
                col3str += "<br>" + GetFunkcja(ph);
                col3str += "<br>" + ph.Etat.OkresZatrudnienia.From;
                col3str += "<br>" + CaptionAttribute.EnumToString(ph.Etat.RodzajZatrudnienia);
                col3.EditValue = col3str;
                                
                string col4str = "";
                try {
                    if (ph.Etat.Zaszeregowanie.TypStawki == Soneta.Kadry.TypStawkiZaszeregowania.Minimalna)
                        col4str = "minimalna";
                    else
                        col4str = ph.Etat.Zaszeregowanie.Stawka.ToString();
                }
                catch (AccessException) {
                }
                try {
                    col4str += "<br>" + CaptionAttribute.EnumToString(ph.Etat.Zaszeregowanie.RodzajStawki);
                }
                catch (AccessException) {
                    col4str += "<br>";
                }
                col4str += "<br>" + ph.Etat.Wymiar;
                col4.EditValue = col4str;
            }

            string GetStanowisko(PracHistoria ph) {
                string stanowiskoPelne = "";
                if (srpars.PelneStanowisko)
                    stanowiskoPelne = ph.Etat.StanowiskoPełne;
                if (stanowiskoPelne.Length == 0)
                    stanowiskoPelne = ph.Etat.Stanowisko;
                return stanowiskoPelne;
            }

            string GetFunkcja(PracHistoria ph) {
                string funkcjaPelna = "";
                if (srpars.PelnaFunkcja)
                    funkcjaPelna = ph.Etat.FunkcjaPełna;
                if (funkcjaPelna.Length == 0)
                    funkcjaPelna = ph.Etat.Funkcja;
                return funkcjaPelna;
            }

</script>
		
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracListaPełna" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" 
                TypeName="Soneta.Business.Row[], Soneta.Business" 
                oncontextload="dc_ContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="Pełna lista %KTO%|&lt;/strong&gt;%CO%: &lt;strong&gt;%OKRES%" 
                runat="server"></cc1:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace" LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" VAlign="Top" DataMember="#" Caption="LP."></ea:GridColumn>
                    <ea:GridColumn Width="25" VAlign="Top" Caption="Nazwisko<br>Imiona<br>PESEL<br>Data i miejsce urodzenia" ID="col1"></ea:GridColumn>
                    <ea:GridColumn VAlign="Top" Caption="Miejsce zamieszkania<br>Telefon, nr dowodu osobistego<br>Bank<br>Konto" ID="col2"></ea:GridColumn>			
                    <ea:GridColumn Width="24" VAlign="Top" Caption="Stanowisko<br>Funkcja<br>Data zatrud.<br>Rodzaj zatrud." ID="col3"></ea:GridColumn>					
                    <ea:GridColumn Width="14" Align="Right" VAlign="Top" Caption="Stawka<br>Typ stawki<br>Etat" ID="col4"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

